﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class ProviderIdentifiersController : ODataController
    {
        [ODataRoute("ProviderIdentifiers({Id})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] int Id)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            var IdMatch = Id.ToString();

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderId =
                    context.ppms_provideridentifierSet.FirstOrDefault(x => x.ppms_ProviderIdentifier == IdMatch);
                if (ppmsProviderId != null)
                {
                    var ppmsProviderIdsList = new List<ppms_provideridentifier> { ppmsProviderId };
                    var providerId = await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsProviderIdsList, queryType, context);
                    return Request.CreateResponse(providerId); 
                }
                var message = string.Format("Provider Identifier with Identifer Number: {0} not found", Id);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
            
        }

        [ODataRoute("ProviderIdentifiers({Id})/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] int Id)
        {

            var IdMatch = Id.ToString();
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderId =
                    context.ppms_provideridentifierSet.FirstOrDefault(x => x.ppms_ProviderIdentifier == IdMatch);
                if (ppmsProviderId != null)
                {
                    //Lookup and Map the Single Provider
                    var ppmsProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderId.ppms_Provider.Id);
                    var ppmsProviderList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProviderList, "None");
                    return Request.CreateResponse(provider);
                }
                var message = string.Format("Provider with Provider Identifier Number: {0} not found", Id);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }

        }

        [ODataRoute("ProviderIdentifiers({Id})/ReplacementNpi")]
        public async Task<HttpResponseMessage> GetReplacementNpi([FromODataUri] int Id)
        {

            var IdMatch = Id.ToString();
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderId =
                    context.ppms_provideridentifierSet.FirstOrDefault(x => x.ppms_ProviderIdentifier == IdMatch);
                if (ppmsProviderId != null)
                {
                    var ppmsReplacementNpi =
                        context.ppms_provideridentifierSet.FirstOrDefault(i => i.Id == ppmsProviderId.ppms_ReplacementNPI.Id);
                    var ppmsReplacementNpiList = new List<ppms_provideridentifier> { ppmsReplacementNpi };
                    var replacementNpi =
                        await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsReplacementNpiList, "None", context);
                    return Request.CreateResponse(replacementNpi);
                }
                var message = string.Format("Replacement NPI with Provider Identifier Number: {0} not found", Id);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }

        }

        [ODataRoute("ProviderIdentifiers({Id})/Providers")]
        public async Task<HttpResponseMessage> GetProviders([FromODataUri] int Id)
        {
            var IdMatch = Id.ToString();
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderId =
                    context.ppms_provideridentifierSet.FirstOrDefault(x => x.ppms_ProviderIdentifier == IdMatch);
                if (ppmsProviderId != null)
                {
                    var ppmsProviders =
                        context.AccountSet.Where(i => i.ppms_ProviderIdentifier == ppmsProviderId.ppms_ProviderIdentifier);
                    var ppmsProvidersList = ppmsProviders.ToList();
                    var providers =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None");
                    return Request.CreateResponse(providers);
                }
                var message = string.Format("Providers with Provider NPI Number: {0} not found", Id);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }

        }

        [ODataRoute("ProviderIdentifiers({Id})/ProviderIdentifiers")]
        public async Task<HttpResponseMessage> GetNpis([FromODataUri] int Id)
        {
            var IdMatch = Id.ToString();
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderId =
                    context.ppms_provideridentifierSet.FirstOrDefault(x => x.ppms_ProviderIdentifier == IdMatch);
                if (ppmsProviderId != null)
                {
                    var ppmsRelatedProviderIdentifiers =
                        context.ppms_provideridentifierSet.Where(i => i.ppms_ReplacementNPI.Id == ppmsProviderId.Id);
                    var ppmsRelatedProviderIdentifiersList = ppmsRelatedProviderIdentifiers.ToList();
                    var providerIdentifers =
                        await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsRelatedProviderIdentifiersList, "None", context);
                    return Request.CreateResponse(providerIdentifers);
                }
                var message = string.Format("Provider NPI's with Provider NPI Number: {0} not found", Id);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }

        }

        [ODataRoute("ProviderIdentifiers")]
        public async Task<HttpResponseMessage> Get()
        {           
            //This Scenario returns the first 10 Provider Identifiers in the system. .           
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderIds = context.ppms_provideridentifierSet.Where(i => i.ppms_ProviderIdentifier != null).Take(10);
                var ppmsProviderIdsList = ppmsProviderIds.ToList();
                if (ppmsProviderIdsList.Any())
                {
                    //Map Npis
                    var providerIdentifiers = await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsProviderIdsList, "None", context);
                    return Request.CreateResponse(providerIdentifiers);
                }
                var message = "Provider Identifiers Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }          
        }       
    }
}